/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.utils;

import android.graphics.Bitmap;

public class BMPConverterUtil {
    public static final int PALETTE_BW = 0;
    public static final int PALETTE_BWR = 1;
    public static final int PALETTE_BWY = 2;

    public static RGBTriple[] getPalette(int deviceType) {
        RGBTriple[] palette = deviceType == 1 ? new RGBTriple[]{new RGBTriple(0, 0, 0), new RGBTriple(255, 255, 255), new RGBTriple(255, 0, 0)} : (deviceType == 2 ? new RGBTriple[]{new RGBTriple(0, 0, 0), new RGBTriple(255, 255, 255), new RGBTriple(255, 255, 0)} : new RGBTriple[]{new RGBTriple(0, 0, 0), new RGBTriple(255, 255, 255)});
        return palette;
    }

    public static byte[][] floydSteinbergDither(RGBTriple[][] image, RGBTriple[] palette) {
        byte[][] result = new byte[image.length][image[0].length];
        for (int y = 0; y < image.length; ++y) {
            for (int x = 0; x < image[y].length; ++x) {
                byte index;
                RGBTriple currentPixel = image[y][x];
                result[y][x] = index = BMPConverterUtil.findNearestColor(currentPixel, palette);
                for (int i = 0; i < 3; ++i) {
                    int error = (currentPixel.channels[i] & 0xFF) - (palette[index].channels[i] & 0xFF);
                    if (x + 1 < image[0].length) {
                        image[y][x + 1].channels[i] = BMPConverterUtil.plus_truncate_uchar(image[y][x + 1].channels[i], error * 7 >> 4);
                    }
                    if (y + 1 >= image.length) continue;
                    if (x - 1 > 0) {
                        image[y + 1][x - 1].channels[i] = BMPConverterUtil.plus_truncate_uchar(image[y + 1][x - 1].channels[i], error * 3 >> 4);
                    }
                    image[y + 1][x].channels[i] = BMPConverterUtil.plus_truncate_uchar(image[y + 1][x].channels[i], error * 5 >> 4);
                    if (x + 1 >= image[0].length) continue;
                    image[y + 1][x + 1].channels[i] = BMPConverterUtil.plus_truncate_uchar(image[y + 1][x + 1].channels[i], error >> 4);
                }
            }
        }
        return result;
    }

    public static Bitmap floydSteinberg(Bitmap bufferedImage, int deviceType) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        RGBTriple[][] image = new RGBTriple[width][height];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                RGBTriple rgbTriple;
                int pixel = bufferedImage.getPixel(i, j);
                int rx = (pixel & 0xFF0000) >> 16;
                int gx = (pixel & 0xFF00) >> 8;
                int bx = pixel & 0xFF;
                image[i][j] = rgbTriple = new RGBTriple(rx, gx, bx);
            }
        }
        Bitmap newBufferedImage = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)bufferedImage.getConfig());
        byte[][] to = BMPConverterUtil.floydSteinbergDither(image, BMPConverterUtil.getPalette(deviceType));
        int alpha = -16777216;
        for (int i = 0; i < to.length; ++i) {
            for (int j = 0; j < to[i].length; ++j) {
                if (to[i][j] == 0) {
                    newBufferedImage.setPixel(i, j, 0 | alpha);
                    continue;
                }
                if (to[i][j] == 1) {
                    newBufferedImage.setPixel(i, j, 0xFFFFFF | alpha);
                    continue;
                }
                if (to[i][j] == 2 && deviceType == 1) {
                    newBufferedImage.setPixel(i, j, 0xFF0000 | alpha);
                    continue;
                }
                if (to[i][j] != 2 || deviceType != 2) continue;
                newBufferedImage.setPixel(i, j, 0xFFFF00 | alpha);
            }
        }
        return newBufferedImage;
    }

    private static byte plus_truncate_uchar(byte a, int b) {
        if ((a & 0xFF) + b < 0) {
            return 0;
        }
        if ((a & 0xFF) + b > 255) {
            return -1;
        }
        return (byte)(a + b);
    }

    private static byte findNearestColor(RGBTriple color, RGBTriple[] palette) {
        int minDistanceSquared = 195076;
        int bestIndex = 0;
        for (int i = 0; i < palette.length; i = (int)((byte)(i + 1))) {
            int Rdiff = (color.channels[0] & 0xFF) - (palette[i].channels[0] & 0xFF);
            int Gdiff = (color.channels[1] & 0xFF) - (palette[i].channels[1] & 0xFF);
            int Bdiff = (color.channels[2] & 0xFF) - (palette[i].channels[2] & 0xFF);
            int distanceSquared = Rdiff * Rdiff + Gdiff * Gdiff + Bdiff * Bdiff;
            if (distanceSquared >= minDistanceSquared) continue;
            minDistanceSquared = distanceSquared;
            bestIndex = i;
        }
        return (byte)bestIndex;
    }

    public static class RGBTriple {
        public final byte[] channels;

        public RGBTriple(int R, int G, int B) {
            this.channels = new byte[]{(byte)R, (byte)G, (byte)B};
        }
    }
}

